
***********************************************************************
***     ANALYSIS: "Stable relationships, stable participation?"	    ***
***		DATA:   - Pairfam waves 1 to 6, Release 6.0	 				***
***			    - Paradata waves 3 to 7 (available upon request) 	***
***																	***	
*** 	CONTENT:  Descriptive results Sections 4.1 and 4.2,	 		***
***				  Table 2 & Appendix Table A1						*** 
***********************************************************************

clear all
set maxvar 10000
set more off
set varabbrev off

global path1 `""datapath""'  
cd $path1	


*** Section 4.1	Demographic and Relationship Profiles of Respondents in LAT and Cohabiting Relationships

** Sample: Two consecutive observations & partner in wave t-2
use attrition_restr, clear
drop if waveb==1

* Percentage LAT respondents
tab latattr

* Separation Rates
tab latattr hpsep, row
tab cohort hpsep, row

* Unstable relationship prior to separation
tab hpsep instabattr if latattr==1, row chi2		// LAT
tab hpsep instabattr if latattr==0, row chi2		// Cohabiting


** Sample: Two consecutive observations with same partner prior to wave t
use attrition_restr2, clear
drop if waveb==1

* Percentage LAT respondents
tab lat

* Changes to relationship instability by relationship status and cohort
tab lat diffinstab, row
tab cohort diffinstab, row



** Appendix Table A1: Descriptive statistics of living apart together (LAT) and cohabiting respondents

** Sample: Two consecutive observations & partner in wave t-2
use attrition_restr, clear
drop if waveb==1 

* Total
tab latattr

* Cohort
tab latattr cohort, row 

* Relationship duration
gen reldurh=reldur_yattr
recode reldurh (0 1=1) (2=2) (3/max=3)
tab reldurh, m

tab latattr reldurh, row chi2

* Children
tab latattr kidsalv, row chi2

* Change in employment status
tab latattr changework, row chi2

* Instability of relationship
tab latattr instabattr, row



*** Section 4.2 Bivariate Associations

** Table 2: Response rates by separation and changes toward relationship instability

** Sample: Full sample
use attrition_full, clear
drop if waveb==1

tab presponse
tab pcontact
tab pcoop


** Sample: Two consecutive observations & partner in wave t-2
use attrition_restr, clear
drop if waveb==1

tab presponse
tab pcontact
tab pcoop

* Separation
tab presponse hpsep, row col chi2		
tab pcontact hpsep, row col chi2
tab pcoop hpsep, row col chi2

* LAT
tab presponse hpsep if latattr==1, row col chi2
tab pcontact hpsep if latattr==1, row col chi2
tab pcoop hpsep if latattr==1, row col chi2

* Cohabiting
tab presponse hpsep if latattr==0, row col chi2
tab pcontact hpsep if latattr==0, row col chi2
tab pcoop hpsep if latattr==0, row col chi2


** Sample: Two consecutive observations with same partner prior to wave t
use attrition_restr2, clear
drop if waveb==1

tab presponse 
tab pcontact
tab pcoop

* Change toward relationship instability
tab presponse diffinstab, row col chi2
tab pcontact diffinstab, row col chi2
tab pcoop diffinstab, row col chi2 

* LAT
tab presponse diffinstab if lat==1, row col chi2
tab pcontact diffinstab if lat==1, row col chi2
tab pcoop diffinstab if lat==1, row col chi2

* Cohabiting
tab presponse diffinstab if lat==0, row col chi2
tab pcontact diffinstab if lat==0, row col chi2
tab pcoop diffinstab if lat==0, row col chi2

